/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Port.c
  \brief    	This file Initialize all GPIO pins contained in Port \n
              Configuration structure. All values are initialized  \n
              outputs.
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	4/14/2008 5:37:45 PM
  \warning    User must be aware about which GPIO pins shall be used as Pwm channels.
  
  * History:
  
*/

/** Reference Port parameters from Port Config file */
#include "Port.h"

/**
 * \brief     Initialize all GPIO pins contained in Port Configuration \n
              structure as Outputs. 
 * \author    R01160
 * \param     
 * \return    none
 * \todo
 * \warning   Only pins contained in Pwm_ChannelConfig structure will be configured.
 */  
 void vfnPort_Init(const Pwm_ChannelConfigType *PortCfgPtr)
 {
   /** Used to count the amount of Port pins to configure */
   uint32_t u32PortCntr = (uint32_t)0;
   /** Used to get Port pin offset */
   uint8_t u8PortPinOffset = (uint8_t)0;
     
   /** Is current Port last in the Configuration Structure? */
   for(u32PortCntr = PWM_MAX_CHANNELS; u32PortCntr > (uint32_t)0 ; u32PortCntr--)
   {
     /* Get current Port Pin Offset to calculate physical address */
     u8PortPinOffset = (&PortCfgPtr[(uint32_t)u32PortCntr - (uint32_t)1])->u8Pwm_Port_Channel;
     /* Configure current Pin Pad as Output */
     SIU_PCR_ADDR(u8PortPinOffset, SET_AS_OUTPUT);
     /* Set current pin state as High or Low */
     SIU_GPDO_ADDR(u8PortPinOffset,PWM_HIGH); 
   }
   
 #if (DIAGNOSTICS == ON)   /* Check if Diagnostics is needed */ 	
  	for(u32PortCntr = MAX_ADC_CHANNELS ; u32PortCntr > 0 ; u32PortCntr-- )
  	{
  	   /* Configure current Pin Pad as Input */
       SIU_PCR_ADDR((uint8_t)PortCfgPtr->u32Adc_Channel_No, SET_AS_INPUT); 
  	}
 #endif  	
}